## ----------------------------------------------------
## provides Sampler for Germany Cancer with one disease
## -->> openBUGS  <<-- ##
rm(list=ls())
require(BRugs)
require(R2OpenBUGS)

modelCheck("model.txt")

openBugs <- bugs(data="data.txt",
              inits=function(){list(kappaU=10, kappaV=100, intercept=1)},
              parameters=c("kappaU","u", "kappaV","v","intercept"),
              model.file="model.txt",
              n.chains=1, n.iter=15000, n.burnin=5000,
              n.thin=20, bugs.seed=2)

save(openBugs, file="openBugs.RData")


